# -*- coding: utf-8 -*-
"""

Sis skriptas paima BIBTeX BIB faila ir kompiliacijos metu sugeneruota BBL faila. Sugeneruoja DOCX faila kuriame citavimo tvarka surasyti cituojami straipsniai ir ju raktai. 

Reikia instaliuoti papildomas bibiliotekas, jos prienamos per pip ar conda

DOCX failas turi buti uzdarytas, kad i ji rasyt


"""


"""
#dict_keys(['da', 'unique-id', 'doc-delivery-number', 'journal-iso', 'usage-count-since-2013', 
'usage-count-last-180-days', 'times-cited', 'number-of-cited-references', 'funding-text',
'funding-acknowledgement', 'orcid-numbers', 'researcherid-numbers', 'author-email',
 'web-of-science-categories', 'research-areas', 'keywords-plus', 'keywords', 'eissn', 
 'issn', 'doi', 'affiliation', 'language', 'type', 'address', 'publisher', 'abstract', 
 'month', 'pages', 'number', 'volume', 'year', 'journal', 'title', 'author', 'ENTRYTYPE', 
 'ID'])
"""


LT_Names = {'Gaizauskas':'Gaižauskas', 'Franckevicius':'Franckevičius', 'Matijosius':'Matijošius',
            'Smilgevicius':'Smilgevičius', 'Vaicaitis':'Vaičaitis', 'Pasiskevicius':'Pašiškevičius',
            'Baltuska':'Baltuška', 'Adomavicius':'Adomavičius', 'Alisauskas':'Ališauskas',
            'Pyragaite':'Pyragaitė', 'Rekstyte':'Rekštytė', 'Tickunas':'Tičkūnas',
            'Zukauskas':'Žukauskas', 'Matulaitiene':'Matulaitienė', 'Tomasiunas':'Tomašiūnas',
            'Lukosevicius':'Lukoševičius', 'Kaskelyte':'Kaškelytė', 'Puisys':'Puišys',
            'Marcinkeviciute':'Marcinkevičiūtė', 'Kaskelye':'Kaškelytė',
            'Staliunas':'Staliūnas', 'Maigyte':'Maigytė', 'Radziunas':'Radžiūnas',
            'Gailevicius':'Gailevičius', 'Steponkevicius':'Steponkevičius',
            'Zeimys':'Žeimys', 'Stepcinkevicius':'Steponkevičius', 'Balachninaite':'Balachninaitė',
            'Tamuliene':'Tamulienė', 'Pipinyte':'Pipinytė', 'Kuliesaite':'Kuliešaitė',
            'Staseviclus':'Stasevičius', 'Stankevicitute':'Stankevičiūtė'}

LTX_Names = {r'Gai\ifmmode \check{z}\else ž\fi{}auskas':'Gaižauskas', 
             r'Tamo\ifmmode \check{s}\else š\fi{}auskas':'Tamošauskas',
             r'Gra{ž}ulevi{č}i{ū}t{ė}': 'Gražulevičiūtė', 'Tamo{š}auskas':'Tamošauskas',
             r'Gra\ifmmode \check{z}\else ž\fi{}ulevi\ifmmode \check{c}\else č\fi{}i\ifmmode \bar{u}\else ū\fi{}t\ifmmode \dot{e}\else ė\fi{}': 'Gražulevičiūtė'}

def st(str_in):
    return str_in.replace('\n',' ').strip('}').strip('{').strip().replace('  ',' ')\
    .replace('\%','%')
    
def stpg(str_in):
    return st(str_in).replace('--','-').replace('--','-').replace('-',u'\u2013')

# conda install -c conda-forge python-docx
# conda install -c conda-forge bibtexparser
    
import LaTexAccents

import bibtexparser
from bibtexparser.bparser import BibTexParser
from docx import Document 

from yattag import Doc

bp = 'ThesisTemplate_bib.bib'

#N_max = 10

#bp = 'Staliunas.bib'
bblf_fn = 'ThesisTemplate.bbl'

with open(bblf_fn, 'r', encoding = 'utf-8') as f:
    bblf_txt = f.read()
    
bblf_ep = bblf_txt.split('\\bibitem{')

bbl_ok = []

for bepe in bblf_ep[1:]:
    bbl_ok.append(bepe.split('}')[0])


parser = BibTexParser(common_strings=True)

with open(bp, encoding='utf-8') as bibtex_file:
    bib_database = bibtexparser.load(bibtex_file, parser)
    
    
T_encode = LaTexAccents.LaTexAccents_to_UTF8() # initialize the accent transformer class instance
    
document = Document()

    
BBD = {}

for bde in bib_database.entries:
    BBD[bde['ID']] = bde
    
    
    
    
for i, bid in enumerate(bbl_ok):
    bde = BBD[bid]
    
    auth_raw = bde['author']
    auth_raw = T_encode.decode_Tex_Accents(auth_raw)
    
    for nonLTX, withLTX in LTX_Names.items():
        auth_raw = auth_raw.replace(nonLTX, withLTX)
    
    auth_arr = auth_raw.replace('\n',' ').split('and')
    auth_new = []
    
    
    
    for a in auth_arr:
        if ',' in a:
            ast = a.strip()
            aels = ast.replace(', ',',').split(',')
            
            inits = []
            for firn in aels[1].replace('-',' ').split(' '):
                inits.append(firn.strip().upper()[0] + '.')
            
            auth_new.append('\xa0'.join(inits) + '\xa0' + aels[0])
        else:
            auth_new.append(a.strip())
#            auth_new.append(aels[1].replace(' ',' ')[0] + '.\xa0' + aels[0])
    
    auth_str = ', '.join(auth_new)
#    if not auth_new:
#        auth_str = auth_raw
    
    pg_str = 'ERROR'
    
    if 'pages' in bde:
        pg_str = stpg(bde['pages'])
    elif 'article-number' in bde:
        pg_str = stpg(bde['article-number'])
        
    title_str = st(bde['title'])
    
    if 'journal-iso' in bde:
        if 'Lith. J. Phys.' in bde['journal-iso']:
            title_str = st(bde['title']).lower()
            title_str = title_str[0].upper() + title_str[1:]
    
    jour_str = ''
    if 'journal' in bde:
        jour_str = st(bde['journal'])
    if 'journal-iso' in bde:
        jour_str = st(bde['journal-iso'])
        
    vol_str = ''
    if 'volume' in bde:
        vol_str = st(bde['volume'])
        
    p = document.add_paragraph(f'[{bid}] ' + auth_str + ', ' + title_str + ', ' + jour_str + ' ')
    p.add_run(vol_str).bold = True
    p.add_run(', ' + pg_str + ' (' + st(bde['year']) +  ').')
    
    paper_line = str(i) + ' ' + f'[{bid}] '  + auth_str + ', ' + title_str + ', ' + jour_str + ' ' +\
    vol_str + ', ' + pg_str + ' (' + st(bde['year']) +  ').'
    
    print(paper_line)
    print('\n')
    
document.save('keys_papers.docx')
    
